<?php
/**
 * Copyright (C) 2014-2020 ServMask Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * ███████╗███████╗██████╗ ██╗   ██╗███╗   ███╗ █████╗ ███████╗██╗  ██╗
 * ██╔════╝██╔════╝██╔══██╗██║   ██║████╗ ████║██╔══██╗██╔════╝██║ ██╔╝
 * ███████╗█████╗  ██████╔╝██║   ██║██╔████╔██║███████║███████╗█████╔╝
 * ╚════██║██╔══╝  ██╔══██╗╚██╗ ██╔╝██║╚██╔╝██║██╔══██║╚════██║██╔═██╗
 * ███████║███████╗██║  ██║ ╚████╔╝ ██║ ╚═╝ ██║██║  ██║███████║██║  ██╗
 * ╚══════╝╚══════╝╚═╝  ╚═╝  ╚═══╝  ╚═╝     ╚═╝╚═╝  ╚═╝╚══════╝╚═╝  ╚═╝
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Kangaroos cannot jump here' );
}
?>

<div class="ai1wm-whats-new-container">
	<div class="ai1wm-whats-new-hero-container">
		<img src="<?php echo wp_make_link_relative( AI1WM_URL ); ?>/lib/view/assets/img/whats-new/hero.png?v=<?php echo AI1WM_VERSION; ?>" />
		<div class="ai1wm-whats-hew-hero-text">
			<div class="ai1wm-whats-new-hero-date">05/24/2022</div>
			<div class="ai1wm-whats-new-hero-title">Introducing the "What's New" page</div>
			<div class="ai1wm-whats-new-hero-content">Want to be the first to know the latest features coming to the All-in-One WP Migration plugin? Take a glance at the “what’s new” page, and you will get up to speed with the newest features we have added, see common use-cases of the features and learn unique ways to use these new features.</div>
		</div>
	</div>

	<div class="ai1wm-whats-new-line"></div>

	<div class="ai1wm-whats-new-block">
		<img src="<?php echo wp_make_link_relative( AI1WM_URL ); ?>/lib/view/assets/img/whats-new/version-6.jpg" />
		<div class="ai1wm-whats-new-block-text">
			<div class="ai1wm-whats-new-block-title">Updated for WordPress version 6.0</div>
			<div class="ai1wm-whats-new-block-content">WordPress 6.0 is bringing a ton of new features and enhancements to the way we build WordPress sites, and the All-in-One WP Migration plugin has been updated to support this new and exciting iteration of WordPress.<br /><br />The All-in-One WP Migration plugin has been upgraded, tested, and confirmed to run smoothly on WordPress 6.0. As a result, when you update your websites to the latest version of WordPress, you will still enjoy the same seamless migration of websites that the All-in-One WP Migration plugin is known for – only at faster speeds and tighter security!</div>
		</div>
	</div>

	<div class="ai1wm-whats-new-block ai1wm-whats-new-block-reverse">
		<img src="<?php echo wp_make_link_relative( AI1WM_URL ); ?>/lib/view/assets/img/whats-new/list-archive.gif" />
		<div class="ai1wm-whats-new-block-text">
			<div class="ai1wm-whats-new-block-title">List the contents of backups</div>
			<div class="ai1wm-whats-new-block-content">Isn’t it annoying and frustrating when you have to resort to technical workarounds or leave WordPress to see and download items from your WordPress backup file?<br /><br />We know it is. That’s why one of the new features we have added to the All-in-One WP Migration plugin is the ability to go through a list of all the items in your WordPress backup file, then select and download the content you need without leaving your WordPress dashboard.</div>
		</div>
	</div>

</div>
